-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Dec 12, 2024 at 02:31 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `gestion_commerciale`
--

-- --------------------------------------------------------

--
-- Table structure for table `achats`
--

CREATE TABLE `achats` (
  `id_achat` int(11) NOT NULL,
  `id_fournisseur` int(11) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `numero_achat` varchar(50) NOT NULL,
  `date_achat` datetime NOT NULL,
  `montant_total` decimal(10,2) NOT NULL DEFAULT 0.00,
  `type_paiement` enum('Cash','Tranche') NOT NULL,
  `statut_paiement` enum('En attente','Partiel','Payé') DEFAULT 'En attente',
  `commentaire` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acodnum`
--

CREATE TABLE `acodnum` (
  `Code` int(11) NOT NULL,
  `CODNUM` varchar(10) NOT NULL,
  `CREDAT` date DEFAULT current_timestamp(),
  `CRETIM` time DEFAULT current_timestamp(),
  `user_cre` varchar(10) DEFAULT NULL,
  `DES` varchar(50) DEFAULT NULL,
  `LNG` int(11) DEFAULT NULL,
  `NIVRAZ` varchar(50) DEFAULT NULL,
  `POSCTE` varchar(30) DEFAULT NULL,
  `POSCTE1` varchar(30) DEFAULT NULL,
  `POSCTE2` varchar(30) DEFAULT NULL,
  `POSCTE3` varchar(50) DEFAULT NULL,
  `Formule` varchar(10) DEFAULT NULL,
  `POSTYP1` int(11) DEFAULT NULL,
  `POSTYP2` int(11) DEFAULT NULL,
  `POSTYP3` int(11) DEFAULT NULL,
  `POSTYP4` int(11) DEFAULT NULL,
  `POSTYP5` int(11) DEFAULT NULL,
  `VAL` int(11) DEFAULT NULL,
  `TYP` enum('Alphanumerique','Numerique') DEFAULT NULL,
  `UPDDAT` date DEFAULT NULL,
  `UPDTIM` time DEFAULT NULL,
  `user_upd` varchar(3) DEFAULT NULL,
  `LastResetDate` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `avalnum`
--

CREATE TABLE `avalnum` (
  `Code` int(255) NOT NULL,
  `CODNUM` varchar(40) NOT NULL,
  `PERIODE` date DEFAULT NULL,
  `SITE` varchar(255) DEFAULT NULL,
  `Value` int(11) NOT NULL,
  `user_cre` varchar(50) DEFAULT NULL,
  `date_cre` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_upd` varchar(50) DEFAULT NULL,
  `date_upd` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bsgcod`
--

CREATE TABLE `bsgcod` (
  `Code` int(11) NOT NULL,
  `tier` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `CODNUM` varchar(50) NOT NULL,
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id_categorie` int(11) NOT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `reference` varchar(50) NOT NULL,
  `nom_categorie` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `client`
--

CREATE TABLE `client` (
  `id_client` int(11) NOT NULL,
  `Code_Client` varchar(50) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `nom` varchar(50) NOT NULL,
  `prenom` varchar(50) NOT NULL,
  `adresse` text DEFAULT NULL,
  `telephone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `cin` varchar(50) DEFAULT NULL,
  `grant` varchar(255) DEFAULT NULL,
  `description` enum('En Test','Confiance','N''est pas Confiance') DEFAULT NULL,
  `profession` varchar(255) DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `details_achats`
--

CREATE TABLE `details_achats` (
  `id_detail_achat` int(11) NOT NULL,
  `id_achat` int(11) DEFAULT NULL,
  `id_produit` int(11) DEFAULT NULL,
  `quantite` int(11) NOT NULL,
  `prix_achat_unitaire` decimal(10,2) NOT NULL,
  `montant_total` decimal(10,2) NOT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `details_ventes`
--

CREATE TABLE `details_ventes` (
  `id_detail_vente` int(11) NOT NULL,
  `id_vente` int(11) DEFAULT NULL,
  `id_produit` int(11) DEFAULT NULL,
  `quantite` int(11) NOT NULL,
  `prix_vente_unitaire` decimal(10,2) NOT NULL,
  `montant_total` decimal(10,2) NOT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fournisseur`
--

CREATE TABLE `fournisseur` (
  `id_fournisseur` int(11) NOT NULL,
  `Code_Fournisseur` varchar(50) NOT NULL,
  `categorie_code` int(11) NOT NULL,
  `raison_sociale` varchar(100) NOT NULL,
  `adresse` text DEFAULT NULL,
  `telephone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `site_web` varchar(100) DEFAULT NULL,
  `numero_fiscal` varchar(50) DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `marque`
--

CREATE TABLE `marque` (
  `id_marque` int(11) NOT NULL,
  `id_categorie` int(11) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mouvements_stock`
--

CREATE TABLE `mouvements_stock` (
  `id_mouvement` int(11) NOT NULL,
  `id_produit` int(11) DEFAULT NULL,
  `type_mouvement` enum('Entrée','Sortie') NOT NULL,
  `quantite` int(11) NOT NULL,
  `date_mouvement` datetime NOT NULL,
  `source_mouvement` enum('Achat','Vente','Ajustement') NOT NULL,
  `id_source` int(11) DEFAULT NULL,
  `commentaire` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mouvement_historique`
--

CREATE TABLE `mouvement_historique` (
  `Code` int(11) NOT NULL,
  `user` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `date_cre` timestamp NULL DEFAULT current_timestamp(),
  `date_upd` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tablename` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `page` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paiements_clients_cash`
--

CREATE TABLE `paiements_clients_cash` (
  `id_paiement_cash` int(11) NOT NULL,
  `id_vente` int(11) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `numero_paiement` varchar(50) NOT NULL,
  `date_paiement` datetime NOT NULL,
  `montant_a_payer` decimal(10,2) NOT NULL,
  `montant_paye` decimal(10,2) NOT NULL,
  `mode_paiement` enum('Espèces','Chèque','Virement','Carte') NOT NULL,
  `reference_paiement` varchar(100) DEFAULT NULL,
  `commentaire` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paiements_clients_tranches`
--

CREATE TABLE `paiements_clients_tranches` (
  `id_paiement_tranche` int(11) NOT NULL,
  `id_vente` int(11) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `numero_paiement` varchar(50) NOT NULL,
  `nombre_tranches` int(11) NOT NULL,
  `montant_total` decimal(10,2) NOT NULL,
  `montant_par_tranche` decimal(10,2) NOT NULL,
  `date_debut` date NOT NULL,
  `periodicite_jours` int(11) NOT NULL DEFAULT 30,
  `statut_tranches` enum('En cours','Terminé') DEFAULT 'En cours',
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paiements_fournisseurs_cash`
--

CREATE TABLE `paiements_fournisseurs_cash` (
  `id_paiement_cash` int(11) NOT NULL,
  `id_achat` int(11) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `numero_paiement` varchar(50) NOT NULL,
  `date_paiement` datetime NOT NULL,
  `montant_a_payer` decimal(10,2) NOT NULL,
  `montant_paye` decimal(10,2) NOT NULL,
  `mode_paiement` enum('Espèces','Chèque','Virement','Carte') NOT NULL,
  `reference_paiement` varchar(100) DEFAULT NULL,
  `commentaire` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `paiements_fournisseurs_tranches`
--

CREATE TABLE `paiements_fournisseurs_tranches` (
  `id_paiement_tranche` int(11) NOT NULL,
  `id_achat` int(11) DEFAULT NULL,
  `categorie_code` int(11) NOT NULL,
  `numero_paiement` varchar(50) DEFAULT NULL,
  `nombre_tranches` int(11) NOT NULL,
  `montant_total` decimal(10,2) NOT NULL,
  `montant_par_tranche` decimal(10,2) NOT NULL,
  `date_debut` date NOT NULL,
  `periodicite_jours` int(11) NOT NULL DEFAULT 30,
  `statut_tranches` enum('En cours','Terminé') DEFAULT 'En cours',
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `poscte`
--

CREATE TABLE `poscte` (
  `description` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `produits`
--

CREATE TABLE `produits` (
  `id_produit` int(11) NOT NULL,
  `id_categorie` int(11) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `reference` varchar(50) NOT NULL,
  `unite` varchar(10) DEFAULT NULL,
  `tva` float DEFAULT NULL,
  `designation` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `id_marque` int(11) DEFAULT NULL,
  `prix_achat` decimal(10,2) NOT NULL,
  `prix_vente` decimal(10,2) NOT NULL,
  `stock_minimum` int(11) DEFAULT 0,
  `stock_actuel` int(11) DEFAULT 0,
  `garantie` int(10) DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `profile`
--

CREATE TABLE `profile` (
  `idAPU` int(11) NOT NULL,
  `profile` varchar(50) NOT NULL,
  `page` varchar(50) NOT NULL,
  `visibility` tinyint(1) NOT NULL DEFAULT 0,
  `op_add` tinyint(1) NOT NULL DEFAULT 0,
  `op_edit` tinyint(1) NOT NULL DEFAULT 0,
  `op_delete` tinyint(1) NOT NULL DEFAULT 0,
  `date_c` date NOT NULL DEFAULT current_timestamp(),
  `user_cre` varchar(30) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `profiles`
--

CREATE TABLE `profiles` (
  `profile` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reglements_tranches_clients`
--

CREATE TABLE `reglements_tranches_clients` (
  `id_reglement` int(11) NOT NULL,
  `id_paiement_tranche` int(11) DEFAULT NULL,
  `numero_tranche` int(11) NOT NULL,
  `date_echeance` date NOT NULL,
  `montant` decimal(10,2) NOT NULL,
  `date_paiement` date DEFAULT NULL,
  `mode_paiement` enum('Espèces','Chèque','Virement','Carte') DEFAULT NULL,
  `reference_paiement` varchar(100) DEFAULT NULL,
  `statut_reglements` enum('En attente','Payé','En retard') DEFAULT 'En attente',
  `commentaire` text DEFAULT NULL,
  `user_cre` varchar(50) NOT NULL,
  `date_usr` datetime NOT NULL DEFAULT current_timestamp(),
  `user_upd` varchar(50) DEFAULT NULL,
  `date_upd` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reglements_tranches_fournisseurs`
--

CREATE TABLE `reglements_tranches_fournisseurs` (
  `id_reglement` int(11) NOT NULL,
  `id_paiement_tranche` int(11) DEFAULT NULL,
  `numero_tranche` int(11) NOT NULL,
  `date_echeance` date NOT NULL,
  `montant` decimal(10,2) NOT NULL,
  `date_paiement` date DEFAULT NULL,
  `mode_paiement` enum('Espèces','Chèque','Virement','Carte') DEFAULT NULL,
  `reference_paiement` varchar(100) DEFAULT NULL,
  `statut_reglements` enum('En attente','Payé','En retard') DEFAULT 'En attente',
  `commentaire` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `role` varchar(50) NOT NULL,
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `societes`
--

CREATE TABLE `societes` (
  `Code` int(11) NOT NULL,
  `description` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiers`
--

CREATE TABLE `tiers` (
  `description` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `idUser` int(11) NOT NULL,
  `username` varchar(30) NOT NULL,
  `password` varchar(250) NOT NULL,
  `profile` varchar(50) NOT NULL,
  `role` varchar(50) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `date_c` date NOT NULL DEFAULT current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `first_login` tinyint(1) DEFAULT 1,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ventes`
--

CREATE TABLE `ventes` (
  `id_vente` int(11) NOT NULL,
  `id_client` int(11) DEFAULT NULL,
  `categorie_code` int(11) DEFAULT NULL,
  `numero_vente` varchar(50) NOT NULL,
  `date_vente` datetime NOT NULL,
  `montant_total` decimal(10,2) NOT NULL DEFAULT 0.00,
  `type_paiement` enum('Cash','Tranche') NOT NULL,
  `statut_paiement` enum('En attente','Partiel','Payé') DEFAULT 'En attente',
  `commentaire` text DEFAULT NULL,
  `date_cre` datetime DEFAULT current_timestamp(),
  `date_upd` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_cre` varchar(50) NOT NULL,
  `user_upd` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `achats`
--
ALTER TABLE `achats`
  ADD PRIMARY KEY (`id_achat`),
  ADD UNIQUE KEY `numero_achat` (`numero_achat`),
  ADD KEY `id_fournisseur` (`id_fournisseur`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `acodnum`
--
ALTER TABLE `acodnum`
  ADD PRIMARY KEY (`Code`),
  ADD UNIQUE KEY `CODNUM` (`CODNUM`),
  ADD KEY `POSCTE` (`POSCTE`),
  ADD KEY `POSCTE1` (`POSCTE1`),
  ADD KEY `POSCTE2` (`POSCTE2`),
  ADD KEY `POSCTE3` (`POSCTE3`);

--
-- Indexes for table `avalnum`
--
ALTER TABLE `avalnum`
  ADD PRIMARY KEY (`Code`),
  ADD UNIQUE KEY `CODNUM` (`CODNUM`,`PERIODE`);

--
-- Indexes for table `bsgcod`
--
ALTER TABLE `bsgcod`
  ADD PRIMARY KEY (`Code`),
  ADD KEY `tier` (`tier`),
  ADD KEY `CODNUM` (`CODNUM`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id_categorie`),
  ADD KEY `categorie_code` (`categorie_code`),
  ADD KEY `reference` (`reference`);

--
-- Indexes for table `client`
--
ALTER TABLE `client`
  ADD PRIMARY KEY (`id_client`),
  ADD UNIQUE KEY `Code_Client` (`Code_Client`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `details_achats`
--
ALTER TABLE `details_achats`
  ADD PRIMARY KEY (`id_detail_achat`),
  ADD KEY `idx_details_achats_achat` (`id_achat`),
  ADD KEY `idx_details_achats_produit` (`id_produit`);

--
-- Indexes for table `details_ventes`
--
ALTER TABLE `details_ventes`
  ADD PRIMARY KEY (`id_detail_vente`),
  ADD KEY `idx_details_ventes_vente` (`id_vente`),
  ADD KEY `idx_details_ventes_produit` (`id_produit`);

--
-- Indexes for table `fournisseur`
--
ALTER TABLE `fournisseur`
  ADD PRIMARY KEY (`id_fournisseur`),
  ADD UNIQUE KEY `Code_Fournisseur` (`Code_Fournisseur`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `marque`
--
ALTER TABLE `marque`
  ADD PRIMARY KEY (`id_marque`),
  ADD KEY `id_categorie` (`id_categorie`);

--
-- Indexes for table `mouvements_stock`
--
ALTER TABLE `mouvements_stock`
  ADD PRIMARY KEY (`id_mouvement`),
  ADD KEY `idx_mouvements_stock_produit` (`id_produit`);

--
-- Indexes for table `mouvement_historique`
--
ALTER TABLE `mouvement_historique`
  ADD PRIMARY KEY (`Code`);

--
-- Indexes for table `pages`
--
ALTER TABLE `pages`
  ADD PRIMARY KEY (`page`);

--
-- Indexes for table `paiements_clients_cash`
--
ALTER TABLE `paiements_clients_cash`
  ADD PRIMARY KEY (`id_paiement_cash`),
  ADD UNIQUE KEY `numero_paiement` (`numero_paiement`),
  ADD UNIQUE KEY `id_vente` (`id_vente`),
  ADD KEY `idx_paiements_clients_cash_vente` (`id_vente`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `paiements_clients_tranches`
--
ALTER TABLE `paiements_clients_tranches`
  ADD PRIMARY KEY (`id_paiement_tranche`),
  ADD UNIQUE KEY `numero_paiement` (`numero_paiement`),
  ADD UNIQUE KEY `id_vente` (`id_vente`),
  ADD KEY `idx_paiements_clients_tranches_vente` (`id_vente`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `paiements_fournisseurs_cash`
--
ALTER TABLE `paiements_fournisseurs_cash`
  ADD PRIMARY KEY (`id_paiement_cash`),
  ADD UNIQUE KEY `numero_paiement` (`numero_paiement`),
  ADD KEY `idx_paiements_fournisseurs_cash_achat` (`id_achat`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `paiements_fournisseurs_tranches`
--
ALTER TABLE `paiements_fournisseurs_tranches`
  ADD PRIMARY KEY (`id_paiement_tranche`),
  ADD UNIQUE KEY `id_achat` (`id_achat`),
  ADD UNIQUE KEY `numero_paiement` (`numero_paiement`),
  ADD KEY `idx_paiements_fournisseurs_tranches_achat` (`id_achat`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- Indexes for table `poscte`
--
ALTER TABLE `poscte`
  ADD PRIMARY KEY (`description`);

--
-- Indexes for table `produits`
--
ALTER TABLE `produits`
  ADD PRIMARY KEY (`id_produit`),
  ADD UNIQUE KEY `reference` (`reference`),
  ADD KEY `categorie_code` (`categorie_code`),
  ADD KEY `id_produits_categorie` (`id_categorie`) USING BTREE,
  ADD KEY `id_marque` (`id_marque`);

--
-- Indexes for table `profile`
--
ALTER TABLE `profile`
  ADD PRIMARY KEY (`idAPU`),
  ADD UNIQUE KEY `profile` (`profile`,`page`),
  ADD KEY `page` (`page`);

--
-- Indexes for table `profiles`
--
ALTER TABLE `profiles`
  ADD PRIMARY KEY (`profile`);

--
-- Indexes for table `reglements_tranches_clients`
--
ALTER TABLE `reglements_tranches_clients`
  ADD PRIMARY KEY (`id_reglement`),
  ADD KEY `idx_reglements_clients_paiement` (`id_paiement_tranche`);

--
-- Indexes for table `reglements_tranches_fournisseurs`
--
ALTER TABLE `reglements_tranches_fournisseurs`
  ADD PRIMARY KEY (`id_reglement`),
  ADD KEY `idx_reglements_fournisseurs_paiement` (`id_paiement_tranche`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`role`);

--
-- Indexes for table `societes`
--
ALTER TABLE `societes`
  ADD PRIMARY KEY (`Code`);

--
-- Indexes for table `tiers`
--
ALTER TABLE `tiers`
  ADD PRIMARY KEY (`description`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`idUser`),
  ADD UNIQUE KEY `username` (`username`),
  ADD KEY `profile` (`profile`),
  ADD KEY `role` (`role`);

--
-- Indexes for table `ventes`
--
ALTER TABLE `ventes`
  ADD PRIMARY KEY (`id_vente`),
  ADD UNIQUE KEY `numero_vente` (`numero_vente`),
  ADD KEY `idx_ventes_client` (`id_client`),
  ADD KEY `categorie_code` (`categorie_code`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `achats`
--
ALTER TABLE `achats`
  MODIFY `id_achat` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `acodnum`
--
ALTER TABLE `acodnum`
  MODIFY `Code` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `avalnum`
--
ALTER TABLE `avalnum`
  MODIFY `Code` int(255) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bsgcod`
--
ALTER TABLE `bsgcod`
  MODIFY `Code` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id_categorie` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `client`
--
ALTER TABLE `client`
  MODIFY `id_client` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `details_achats`
--
ALTER TABLE `details_achats`
  MODIFY `id_detail_achat` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `details_ventes`
--
ALTER TABLE `details_ventes`
  MODIFY `id_detail_vente` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `fournisseur`
--
ALTER TABLE `fournisseur`
  MODIFY `id_fournisseur` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `marque`
--
ALTER TABLE `marque`
  MODIFY `id_marque` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `mouvements_stock`
--
ALTER TABLE `mouvements_stock`
  MODIFY `id_mouvement` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `mouvement_historique`
--
ALTER TABLE `mouvement_historique`
  MODIFY `Code` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paiements_clients_cash`
--
ALTER TABLE `paiements_clients_cash`
  MODIFY `id_paiement_cash` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paiements_clients_tranches`
--
ALTER TABLE `paiements_clients_tranches`
  MODIFY `id_paiement_tranche` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paiements_fournisseurs_cash`
--
ALTER TABLE `paiements_fournisseurs_cash`
  MODIFY `id_paiement_cash` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paiements_fournisseurs_tranches`
--
ALTER TABLE `paiements_fournisseurs_tranches`
  MODIFY `id_paiement_tranche` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `produits`
--
ALTER TABLE `produits`
  MODIFY `id_produit` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `profile`
--
ALTER TABLE `profile`
  MODIFY `idAPU` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `reglements_tranches_clients`
--
ALTER TABLE `reglements_tranches_clients`
  MODIFY `id_reglement` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `reglements_tranches_fournisseurs`
--
ALTER TABLE `reglements_tranches_fournisseurs`
  MODIFY `id_reglement` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `societes`
--
ALTER TABLE `societes`
  MODIFY `Code` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `idUser` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ventes`
--
ALTER TABLE `ventes`
  MODIFY `id_vente` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `achats`
--
ALTER TABLE `achats`
  ADD CONSTRAINT `achats_ibfk_1` FOREIGN KEY (`id_fournisseur`) REFERENCES `fournisseur` (`id_fournisseur`),
  ADD CONSTRAINT `achats_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `acodnum`
--
ALTER TABLE `acodnum`
  ADD CONSTRAINT `acodnum_ibfk_6` FOREIGN KEY (`POSCTE`) REFERENCES `poscte` (`description`),
  ADD CONSTRAINT `acodnum_ibfk_7` FOREIGN KEY (`POSCTE1`) REFERENCES `poscte` (`description`),
  ADD CONSTRAINT `acodnum_ibfk_8` FOREIGN KEY (`POSCTE2`) REFERENCES `poscte` (`description`),
  ADD CONSTRAINT `acodnum_ibfk_9` FOREIGN KEY (`POSCTE3`) REFERENCES `poscte` (`description`);

--
-- Constraints for table `bsgcod`
--
ALTER TABLE `bsgcod`
  ADD CONSTRAINT `bsgcod_ibfk_1` FOREIGN KEY (`tier`) REFERENCES `tiers` (`description`),
  ADD CONSTRAINT `bsgcod_ibfk_2` FOREIGN KEY (`CODNUM`) REFERENCES `acodnum` (`CODNUM`);

--
-- Constraints for table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `categories_ibfk_1` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `client`
--
ALTER TABLE `client`
  ADD CONSTRAINT `client_ibfk_1` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `details_achats`
--
ALTER TABLE `details_achats`
  ADD CONSTRAINT `details_achats_ibfk_1` FOREIGN KEY (`id_achat`) REFERENCES `achats` (`id_achat`),
  ADD CONSTRAINT `details_achats_ibfk_2` FOREIGN KEY (`id_produit`) REFERENCES `produits` (`id_produit`);

--
-- Constraints for table `details_ventes`
--
ALTER TABLE `details_ventes`
  ADD CONSTRAINT `details_ventes_ibfk_1` FOREIGN KEY (`id_vente`) REFERENCES `ventes` (`id_vente`),
  ADD CONSTRAINT `details_ventes_ibfk_2` FOREIGN KEY (`id_produit`) REFERENCES `produits` (`id_produit`);

--
-- Constraints for table `fournisseur`
--
ALTER TABLE `fournisseur`
  ADD CONSTRAINT `fournisseur_ibfk_1` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `marque`
--
ALTER TABLE `marque`
  ADD CONSTRAINT `marque_ibfk_1` FOREIGN KEY (`id_categorie`) REFERENCES `categories` (`id_categorie`);

--
-- Constraints for table `mouvements_stock`
--
ALTER TABLE `mouvements_stock`
  ADD CONSTRAINT `mouvements_stock_ibfk_1` FOREIGN KEY (`id_produit`) REFERENCES `produits` (`id_produit`);

--
-- Constraints for table `paiements_clients_cash`
--
ALTER TABLE `paiements_clients_cash`
  ADD CONSTRAINT `paiements_clients_cash_ibfk_1` FOREIGN KEY (`id_vente`) REFERENCES `ventes` (`id_vente`),
  ADD CONSTRAINT `paiements_clients_cash_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `paiements_clients_tranches`
--
ALTER TABLE `paiements_clients_tranches`
  ADD CONSTRAINT `paiements_clients_tranches_ibfk_1` FOREIGN KEY (`id_vente`) REFERENCES `ventes` (`id_vente`),
  ADD CONSTRAINT `paiements_clients_tranches_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `paiements_fournisseurs_cash`
--
ALTER TABLE `paiements_fournisseurs_cash`
  ADD CONSTRAINT `paiements_fournisseurs_cash_ibfk_1` FOREIGN KEY (`id_achat`) REFERENCES `achats` (`id_achat`),
  ADD CONSTRAINT `paiements_fournisseurs_cash_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `paiements_fournisseurs_tranches`
--
ALTER TABLE `paiements_fournisseurs_tranches`
  ADD CONSTRAINT `paiements_fournisseurs_tranches_ibfk_1` FOREIGN KEY (`id_achat`) REFERENCES `achats` (`id_achat`),
  ADD CONSTRAINT `paiements_fournisseurs_tranches_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);

--
-- Constraints for table `produits`
--
ALTER TABLE `produits`
  ADD CONSTRAINT `produits_ibfk_1` FOREIGN KEY (`id_categorie`) REFERENCES `categories` (`id_categorie`),
  ADD CONSTRAINT `produits_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`),
  ADD CONSTRAINT `produits_ibfk_3` FOREIGN KEY (`id_marque`) REFERENCES `marque` (`id_marque`);

--
-- Constraints for table `profile`
--
ALTER TABLE `profile`
  ADD CONSTRAINT `profile_ibfk_2` FOREIGN KEY (`page`) REFERENCES `pages` (`page`),
  ADD CONSTRAINT `profile_ibfk_3` FOREIGN KEY (`profile`) REFERENCES `profiles` (`profile`);

--
-- Constraints for table `reglements_tranches_clients`
--
ALTER TABLE `reglements_tranches_clients`
  ADD CONSTRAINT `reglements_tranches_clients_ibfk_1` FOREIGN KEY (`id_paiement_tranche`) REFERENCES `paiements_clients_tranches` (`id_paiement_tranche`);

--
-- Constraints for table `reglements_tranches_fournisseurs`
--
ALTER TABLE `reglements_tranches_fournisseurs`
  ADD CONSTRAINT `reglements_tranches_fournisseurs_ibfk_1` FOREIGN KEY (`id_paiement_tranche`) REFERENCES `paiements_fournisseurs_tranches` (`id_paiement_tranche`);

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_2` FOREIGN KEY (`profile`) REFERENCES `profiles` (`profile`),
  ADD CONSTRAINT `users_ibfk_3` FOREIGN KEY (`role`) REFERENCES `roles` (`role`);

--
-- Constraints for table `ventes`
--
ALTER TABLE `ventes`
  ADD CONSTRAINT `ventes_ibfk_1` FOREIGN KEY (`id_client`) REFERENCES `client` (`id_client`),
  ADD CONSTRAINT `ventes_ibfk_2` FOREIGN KEY (`categorie_code`) REFERENCES `bsgcod` (`Code`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
