<?php
include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';
setupCORS();

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

requireAuth();

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_mouvement'])) {
        $query = "SELECT * FROM mouvements_stock WHERE id_mouvement = :id_mouvement";
        $params = array(':id_mouvement' => $_GET['id_mouvement']);
        $result = metodGet($query, $params);
        echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
    } else {
        $query = "SELECT * FROM mouvements_stock";
        $result = metodGet($query);
        echo json_encode($result->fetchAll());
    }
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'POST') {
    unset($_POST['METHOD']);

    try {
        $query = "INSERT INTO mouvements_stock (
            id_produit, type_mouvement, quantite, date_mouvement, 
            source_mouvement, id_source, commentaire, user_cre
        ) VALUES (
            :id_produit, :type_mouvement, :quantite, :date_mouvement,
            :source_mouvement, :id_source, :commentaire, :user_cre
        )";

        $queryAutoIncrement = "SELECT MAX(id_mouvement) as id_mouvement FROM mouvements_stock";

        $params = array(
            ':id_produit' => $_POST['id_produit'],
            ':type_mouvement' => $_POST['type_mouvement'],
            ':quantite' => $_POST['quantite'],
            ':date_mouvement' => $_POST['date_mouvement'],
            ':source_mouvement' => $_POST['source_mouvement'],
            ':id_source' => $_POST['id_source'],
            ':commentaire' => $_POST['commentaire'],
            ':user_cre' => $_POST['user_cre']
        );

        $result = metodPost($query, $queryAutoIncrement, $params, 'mouvements_stock');
        echo json_encode($result);
        header("HTTP/1.1 200 OK");
    } catch (Exception $e) {
        header("HTTP/1.1 500 Internal Server Error");
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit();
}

if ($_POST['METHOD'] == 'PUT') {
    unset($_POST['METHOD']);
    $id_mouvement = $_GET['id_mouvement'];

    $query = "UPDATE mouvements_stock SET
        id_produit = :id_produit,
        type_mouvement = :type_mouvement,
        quantite = :quantite,
        date_mouvement = :date_mouvement,
        source_mouvement = :source_mouvement,
        id_source = :id_source,
        commentaire = :commentaire,
        date_upd = :date_upd,
        user_upd = :user_upd
    WHERE id_mouvement = :id_mouvement";

    $params = array(
        ':id_mouvement' => $id_mouvement,
        ':id_produit' => $_POST['id_produit'],
        ':type_mouvement' => $_POST['type_mouvement'],
        ':quantite' => $_POST['quantite'],
        ':date_mouvement' => $_POST['date_mouvement'],
        ':source_mouvement' => $_POST['source_mouvement'],
        ':id_source' => $_POST['id_source'],
        ':commentaire' => $_POST['commentaire'],
        ':date_upd' => date('Y-m-d H:i:s'),
        ':user_upd' => $_POST['user_upd']
    );

    $result = metodPut($query, $params, 'mouvements_stock');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'DELETE') {
    unset($_POST['METHOD']);
    $id_mouvement = $_GET['id_mouvement'];
    $query = "DELETE FROM mouvements_stock WHERE id_mouvement = :id_mouvement";
    $params = array(':id_mouvement' => $id_mouvement);
    $result = metodDelete($query, $params, 'mouvements_stock');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

header("HTTP/1.1 400 Bad Request");
?>
