<?php
// user.php

include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';
setupCORS();

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Protect all routes with authentication
requireAuth();

if ($_SERVER['REQUEST_METHOD'] == 'GET') {


    if (!isset($_GET['idUser'])) {
        requirePermission('utilisateur', 'view');

    }

    if (isset($_GET['idUser'])) {
        $query = "SELECT * FROM users WHERE idUser = :idUser";
        $params = array(':idUser' => $_GET['idUser']);
        $result = metodGet($query, $params);
        echo json_encode($result->fetchAll(PDO::FETCH_ASSOC));
    } else {
        $query = "SELECT * FROM users";
        $result = metodGet($query);
        echo json_encode($result->fetchAll());
    }
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'POST') {
    // Only admins can create new users
    requireAuth(['admin']);

    unset($_POST['METHOD']);
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $profile = $_POST['profile'];
    $role = $_POST['role'];
    $active = $_POST['active'];
    $user_cre = $_POST['user_cre'];
    $query = "INSERT INTO users(username, password, profile, role, user_cre, active) 
              VALUES (:username, :password, :profile, :role, :user_cre, :active)";
    $queryAutoIncrement = "SELECT MAX(idUser) as idUser FROM users";
    $params = array(
        ':username' => $username,
        ':password' => $password,
        ':profile' => $profile,
        ':role' => $role,
        ':user_cre' => $user_cre,
        ':active' => $active
    );
    $result = metodPost($query, $queryAutoIncrement, $params, 'users');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'PUT') {
    unset($_POST['METHOD']);

    // Handle password update
    if (isset($_POST['password'])) {
        $idUser = $_GET['idUser'];
        $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
        $user_upd = $_POST['user_upd'];

        $query = "UPDATE users SET password=:password, user_upd=:user_upd WHERE idUser=:idUser";
        $params = array(
            ':idUser' => $idUser,
            ':password' => $password,
            ':user_upd' => $user_upd
        );
        $result = metodPut($query, $params, 'users');
        echo json_encode($result);
        header("HTTP/1.1 200 OK");
        exit();
    }

    // Handle regular user update
    requireAuth(['admin']) || requirePermission('utilisateur', 'update');
    $idUser = $_GET['idUser'];
    $username = $_POST['username'];
    $profile = $_POST['profile'];
    $role = $_POST['role'];
    $active = $_POST['active'];
    $first_login = $_POST['first_login'];
    $user_upd = $_POST['user_upd'];
    $query = "UPDATE users SET user_upd=:user_upd, username=:username, 
              profile=:profile, role=:role, active=:active, first_login=:first_login 
              WHERE idUser=:idUser";
    $params = array(
        ':idUser' => $idUser,
        ':user_upd' => $user_upd,
        ':username' => $username,
        ':profile' => $profile,
        ':role' => $role,
        ':active' => $active,
        ':first_login' => $first_login
    );
    $result = metodPut($query, $params, 'users');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

if ($_POST['METHOD'] == 'DELETE') {
    // Only admins can delete users
    requireAuth(['admin']) || requirePermission('utilisateur', 'delete');
    unset($_POST['METHOD']);
    $id = $_GET['idUser'];
    $query = "DELETE FROM users WHERE idUser = :id";
    $params = array(':id' => $id);
    $result = metodDelete($query, $params, 'users');
    echo json_encode($result);
    header("HTTP/1.1 200 OK");
    exit();
}

header("HTTP/1.1 400 Bad Request");