<?php
include 'bd/myData.php';
require_once 'auth.php';
include 'cors.php';
setupCORS();

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

requireAuth();

function generateBarcode($reference) {
    // Simplifier la génération pour le débogage
    return $reference; // Retourner simplement la référence pour le test
}

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    try {
        if (isset($_GET['reference'])) {
            $reference = $_GET['reference'];
            
            // Log pour le débogage
            error_log("Reference reçue: " . $reference);
            
            $query = "SELECT p.reference, c.nom_categorie 
                     FROM produits p 
                     JOIN categories c ON p.id_categorie = c.id_categorie 
                     WHERE p.reference = :reference";
            
            $params = array(':reference' => $reference);
            $result = metodGet($query, $params);
            $product = $result->fetch(PDO::FETCH_ASSOC);
            
            // Log pour le débogage
            error_log("Produit trouvé: " . print_r($product, true));
            
            if ($product) {
                $barcode = generateBarcode($reference);
                error_log("Code-barres généré: " . $barcode);
                
                http_response_code(200);
                echo json_encode(['barcode' => $barcode]);
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Product not found']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Reference parameter is required']);
        }
    } catch (Exception $e) {
        error_log("Erreur: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
}
?>